<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="MFMT_MT902002NL">
    <title>ActReference Minimal</title>
    <rule context="$element">
        <!--assert role="error" test="@classCode='CATEGORY' or @classCode='PCPR'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActClass.htm"
            >MFMT_MT902000NL: <value-of select="local-name(.)"/>/@classCode moet 'CATEGORY' of 'PCPR' zijn</assert>
        <assert role="error" test="@moodCode='EVN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActMood.htm#EVN"
            >MFMT_MT902000NL: <value-of select="local-name(.)"/>/@moodCode moet 'EVN' zijn</assert-->
        <let name="codeValue" value="../../hl7:code/@code"/>
        <let name="codeSystem" value="../../hl7:code/@codeSystem"/>
        
        <let name="classCode" value="@classCode"/>
        <let name="classCodeRoot" value="'2.16.840.1.113883.5.6'"/>
        <let name="expectClassCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$classCodeRoot]/@extension"/>
        
        <!-- Niet alle ActRegistryCodes hebben reeds een reference element -->
        <assert role="error" test="@classCode"
            >MFMT_MT902002NL: @classCode is verplicht</assert>
        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $classCode=$expectClassCode"
            >MFMT_MT902002NL: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de classCode van de ActReference '<value-of select="@classCode"/>'. Verwacht werd '<value-of select="$expectClassCode"/>'.</assert>
        
        <let name="moodCode" value="@moodCode"/>
        <let name="moodCodeRoot" value="'2.16.840.1.113883.5.1001'"/>
        <let name="expectMoodCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$moodCodeRoot]/@extension"/>
        
        <assert role="error" test="not($classCode='CATEGORY') or $moodCode='EVN'"
            >MFMT_MT902002NL: @moodCode moet 'EVN' zijn voor categorale aanmeldingen</assert>
        
        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $moodCode=$expectMoodCode"
            >MFMT_MT902002NL: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de moodCode van de ActReference '<value-of select="@moodCode"/>'. Verwacht werd '<value-of select="$expectMoodCode"/>'.</assert>
    </rule>
    
    <title>ActReference/id</title>
    <rule context="$element/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="not(@nullFlavor)"
            >MFMT_MT902002NL: id moet een waarde bevatten</assert>
    </rule>
 </pattern>
